float4x4 g_view_projection_matrix;
float4x4 g_world_matrix;
float4	g_diffuse_mtrl;
float4	g_ambient_mtrl;
texture g_tex0;
texture g_tex1;
float	g_blend;

sampler2D tex0 : TEXUNIT0 = sampler_state
{
     Texture = (g_tex0);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};

sampler2D tex1 : TEXUNIT0 = sampler_state
{
     Texture = (g_tex1);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
};

struct OutputVS
{
	float4 posH		: POSITION;
	float2 UV		: TEXCOORD0;
	float3 Norm		: TEXCOORD1;
};

OutputVS MainVS( float4 posL : POSITION , float3 normal : NORMAL , float2 UV : TEXCOORD0 )
{
	OutputVS outVS = (OutputVS)0;
	
	outVS.posH = posL;
	
	outVS.posH = mul( posL , g_world_matrix );
	outVS.posH = mul( outVS.posH , g_view_projection_matrix );
	
	outVS.UV	= UV;
	outVS.Norm	= mul( normal , g_world_matrix );
	
	return outVS;
}


float4 MainPS( float2 UV : TEXCOORD0 , float3 Light : TEXCOORD1 , float3 Norm : TEXCOORD2 ,
				   float3 View : TEXCOORD3 ) : COLOR
{
	float4 TextureColor0 = tex2D( tex0 , UV );
	float4 TextureColor1 = tex2D( tex1 , UV );
	
	//Calculate diffuse color amount
	float Diff = saturate( dot( normalize( Norm ) , float3( 0.0f , -0.2f , 1.0f ) ) );
	
	return ( TextureColor0 * ( 1.0f - g_blend ) ) + ( TextureColor1 * g_blend ) + g_diffuse_mtrl * Diff;
}

technique Default
{
	pass p0
	{
		VertexShader	= compile vs_3_0 MainVS();
		PixelShader		= compile ps_2_0 MainPS();
	}
}